/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class SwitchButton
extends Button {
    public static final ResourceLocation SWITCH_TEXTURE = new FiguraIdentifier("textures/gui/switch.png");
    public static final Component ON = FiguraText.of("gui.on");
    public static final Component OFF = FiguraText.of("gui.off");
    protected boolean toggled = false;
    private boolean defaultTexture = false;
    private boolean underline = true;
    private float headPos = 0.0f;

    public SwitchButton(int x, int y, int width, int height, Component text, Component tooltip, Button.OnPress pressAction) {
        super(x, y, width, height, text, tooltip, pressAction);
    }

    public SwitchButton(int x, int y, int width, int height, int u, int v, int interactionOffset, ResourceLocation texture, int textureWidth, int textureHeight, Component tooltip, Button.OnPress pressAction) {
        super(x, y, width, height, u, v, interactionOffset, texture, textureWidth, textureHeight, tooltip, pressAction);
    }

    public SwitchButton(int x, int y, int width, int height, Component text, boolean toggled) {
        super(x, y, width, height, text, null, button -> {});
        this.toggled = toggled;
        this.headPos = toggled ? 20.0f : 0.0f;
        this.defaultTexture = true;
    }

    public void onPress() {
        this.toggled = !this.toggled;
        super.onPress();
    }

    @Override
    protected void renderText(GuiGraphics gui, float delta) {
        Component text = this.toggled && this.underline ? this.getMessage().copy().withStyle(ChatFormatting.UNDERLINE) : this.getMessage();
        int x = this.getX() + 1;
        int width = this.getWidth() - 2;
        if (this.defaultTexture) {
            x += 31;
            width -= 31;
        }
        UIHelper.renderCenteredScrollingText(gui, text, x, this.getY(), width, this.getHeight(), this.getTextColor());
    }

    @Override
    protected void renderDefaultTexture(GuiGraphics gui, float delta) {
        if (!this.defaultTexture) {
            super.renderDefaultTexture(gui, delta);
            return;
        }
        UIHelper.enableBlend();
        int x = this.getX();
        int y = this.getY();
        gui.blit(SWITCH_TEXTURE, x + 5, y + 5, 20, 10, 10.0f, (this.toggled ? 20.0f : 0.0f) + (this.isHoveredOrFocused() ? 10.0f : 0.0f), 20, 10, 30, 40);
        this.headPos = (float)Mth.lerp((double)(1.0 - Math.pow(0.2f, delta)), (double)this.headPos, (double)(this.toggled ? 20.0 : 0.0));
        gui.blit(SWITCH_TEXTURE, Math.round((float)x + this.headPos), y, 10, 20, 0.0f, this.isHoveredOrFocused() ? 20.0f : 0.0f, 10, 20, 30, 40);
    }

    @Override
    protected int getV() {
        return this.isToggled() ? 1 : super.getV();
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }
}

